/* @TITLE "queue.h: queue data structure"*/
/* 
 * queue: this is a normal FIFO queue module, with a fixed maximum capacity.
 *
 * David Kotz 1994
 */

/* $Id: queue.h,v 2.0 94/07/17 18:34:58 dfk Exp $ */

#ifndef QUEUE_H
#define QUEUE_H

#ifdef __cplusplus
extern "C" {
#endif 

typedef void *Qitem;          /* a queue item is any pointer */

/* ******************************************************* */
/* CYCLE-COUNTED versions (only usable in USER mode) */
typedef struct queue_s QUEUE; /* Queue handle */

extern QUEUE *MakeQueue(int size, char *debugname); /* make a new queue */
extern void Enqueue(QUEUE *q, Qitem item);
extern void Dequeue(QUEUE *q, Qitem *item);
extern int InQueue(QUEUE *q); /* number currently in queue */
extern boolean EmptyQueue(QUEUE *q); /* TRUE if queue is empty */
extern void FreeQueue(QUEUE *q); /* destroy a queue */

/* ******************************************************* */
/* NON-CYCLE-COUNTED versions (also useful in ENGINE mode) */
typedef struct queue_noncyc_s NCQUEUE; /* Queue handle */

extern NCQUEUE *MakeQueue_noncyc(int size, char *debugname); /* new queue */
extern void Enqueue_noncyc(NCQUEUE *q, Qitem item);
extern void Dequeue_noncyc(NCQUEUE *q, Qitem *item);
extern int InQueue_noncyc(NCQUEUE *q); /* number currently in queue */
extern boolean EmptyQueue_noncyc(NCQUEUE *q); /* TRUE if queue is empty */
extern void FreeQueue_noncyc(NCQUEUE *q); /* destroy a queue */

#ifdef __cplusplus
}
#endif 


#endif /* QUEUE_H */

