#ifndef DISKQUEUE_H
#define DISKQUEUE_H

/*****************************************************************************
 *                                                                           *
 *      File Name:        diskqueue.H                                        *
 *                                                                           *
 *      Function:         Declares the queue class which is a first-in-      *
 *                        first-out queue. The contents of the queue         *
 *                        are disk requests.                                 *
 *                                                                           *
 *      Author:           Yiming Hu                                          *
 *                        hu@ele.uri.edu                                     *
 *                        Department of Electrical & Computer Engineering    *
 *                        University of Rhode Island                         *
 *                        Kingston, RI 02881                                 *
 *                                                                           *
 *****************************************************************************/

//Do not change next line. It is for SCCS version control
//SCCS  @(#)diskqueue.h	V1.2    02/07/96  (in DCD Simulator) (C) Yiming Hu

#include "general.H"

#define MAX_QUEUE_SIZE	100

class  tDiskQueue
{
private:
	tRequestPacket DiskQueue[MAX_QUEUE_SIZE];
	int    nQueueStart;
        int    nQueueEnd;

        int    MaxLength;
        int    CurrentLength;
        int    TotalAccessNum; 
        double AverageTotal;
public:
	tDiskQueue(void);
	void    Init(void);
	BOOLEAN bIsEmpty(void) const;
	void    In(const tRequestPacket *Item);
	void    Out(tRequestPacket * Item);
	BOOLEAN TestTop(tRequestPacket * Item) const;
        int     currentLength() const;
        void    getQueueLength(double& Average, int& Max) const;
};


#endif // DISKQUEUE_H
