#ifndef GENERAL_H
#define GENERAL_H

/*****************************************************************************
 *                                                                           *
 *      File Name:        general.H                                          *
 *                                                                           *
 *      Function:         This file is included by all c files. It defines   *
 *                        generally used macros, constants and data types.   *
 *                                                                           *
 *      Author:           Yiming Hu                                          *
 *                                                                           *
 *      Last Update Date: Nov 2, 1996                                        *
 *                                                                           *
 *****************************************************************************/


//Do not change next line. It is for SCCS version control
//SCCS  @(#)general.h	V3.2    02/07/97  (in DCD Simulator) (C) Yiming Hu   

#include <stdlib.h>

#include "modularize.h"


//---------------------------------------------------------------------------
//       Common data types
//---------------------------------------------------------------------------

typedef unsigned int    UINT;
typedef int             BOOLEAN;
typedef unsigned long   ULONG;
typedef unsigned char   BYTE;


//---------------------------------------------------------------------------
//       General Macros
//---------------------------------------------------------------------------

// For display debugging information
#ifdef DEBUG
# define DEBUG_TRACE(x) {printf x;}
#else
# define DEBUG_TRACE(x) {}
#endif // DEBUG



//---------------------------------------------------------------------------
//       General constants
//---------------------------------------------------------------------------

static const BOOLEAN YES   =  1;
static const BOOLEAN NO    =  0;


// The following names are defined as macros in modularize.h so we have to
// disable them
//static const BOOLEAN TRUE  =  1;
//static const BOOLEAN FALSE =  0;
//static const int FATAL  -1




//Command type
typedef enum tagCommandType {cmdSeek,cmdRead,cmdWrite,cmdVerify, cmdDelay} CommandType; 


typedef void tCallBack(struct tRequestPacket DiskReturnData);


// All the information needed for a disk access is packed into this structure.
// Some information will be passed back to called when the request finishes
//
struct tRequestPacket 
{
    ULONG       RequestNo;

    TICS     	RequestTime;     // Enqueue time
    TICS     	DequeueTime;     // Dequeue (from main queue) time
    TICS        StartTime;       // physical start time
    TICS        FinishTime;      // physical finish time

    CommandType Command;
    ULONG     	DiskNo;          // Disk ID
    ULONG    	LBA;             // Start block (sector) number (Logic Block Address)
    UINT     	SectorCount;     // How many blocks to be accessed
    BYTE	*Data;           // Actual data
				
    void        *Pointer;        // A generic pointer, a caller can put
                                 // a pointer to anything here. When the
                                 // disk simulator calls the callback
                                 // function, this parameter is passed
                                 // back to the callback function.
                                 // This is particularly useful for enabling
                                 // the callback function to access data members
                                 // or functions of an object.

    void        *Pointer1;       // Another generic pointer

    tCallBack   *CallBack;       // Call back function, when the
				 // access finished, this function
			         // will be called

    // constructor
    tRequestPacket(void) 
    { 
        CallBack = NULL; 
        Data     = NULL; 
        Pointer  = NULL; 
        Pointer1 = NULL; 
    };
};





#endif /* GENERAL_H */
