/* @TITLE "diskevent.h: manage a heap of future events"*/
/* 
 * The disk-device module is event driven.  This module keeps the event 
 * request mechanism, which is based on proteus SimRequests, 
 * abstracted away from the bulk of the disk device code. 
 *
 * Functions
 *  	DDEventInit
 *  	DDEventRequest
 *  	DDEventPrint
 *  	DDEventCancel
 *
 * David Kotz 1994
 */

/* $Id: diskevent.h,v 2.0 94/07/17 18:34:51 dfk Exp $ */

#ifndef DISKEVENT_H
#define DISKEVENT_H

#include "time.h"

typedef enum {
  NOP,
  DISKMOVE,
  STARTDISKXFER,
  ENDDISKXFER,
  CONSIDERBUSXFER,
  STARTBUSXFER,
  ENDBUSXFER,
  SENDCOMMAND,
  ENDCOMMAND,
  CONTROLLER,
  SENDSYNCCOMMAND,
  ENDSYNCCOMMAND,
  SENDBUFFERMESG,
  ENDBUFFERMESG,
  SENDDONEMESSAGE,
  ENDDONEMESSAGE
} REQUESTCODE;

typedef void DDEvent;	      /* internally, is a SimRequest */

extern void 	   DDEventInit(void);
extern DDEvent *   DDEventRequest(REQUESTCODE event, TICS eventTime, int disk);
extern void 	   DDEventPrint(FILE *fp, void *req); /* (, SimRequest *) */
extern void 	   DDEventCancel(DDEvent *ddev);
extern void 	   DDEventWakeup(int stid, TICS when); /* note STID not TID */

/* list of disk-device request types, 
 * initialized in diskdevice.c, 
 * used in diskevent.c
 */
typedef void (*DDhandler)(int disk, TICS eventTime);
struct dd_handlers {
  DDhandler handler;	      /* function implementing this event type */
  char name[20];	      /* name of that event type */
};
extern struct dd_handlers DDhandlers[];

#endif /* DISKEVENT_H */
