/* @TITLE "heap.h - interface to heap management implementation */
/* We manage a heap of data,key pairs, where the key could be any 
 * simple data type 
 * and the data is any pointer data type. We allow the caller to add
 * pairs, remote pairs, peek at the top pair, and do delete/add combinations.
 * The latter are efficient because we only reheap once.
 *
 * David Kotz 1990? and 1993
 */

/* $Id: heap.h,v 2.0 94/07/17 18:34:53 dfk Exp $ */

#ifndef HEAP_H
#define HEAP_H


#ifdef __cplusplus
extern "C" {
#endif 


#ifndef DFK
#include "modularize.h"
#endif
#include "diskevent.h"

typedef TICS HeapKey;	        /* type of the key used in heap */

/* heap data */
typedef struct heapdata {
  REQUESTCODE req_code;
  TICS eventTime;
  int disk;
} heapdata;

typedef heapdata   *HeapData;	        /* type of the data used in heap */
typedef struct heap_struct *Heap;       /* handle on a heap */


/* return TRUE if the two requests in the heap match */
#define Matching_REQUESTS(HeapData1, HeapData2)       \
((HeapData1->disk == HeapData2->disk) &&              \
 (HeapData1->req_code == HeapData2->req_code))


/* set up heap to hold maxsize nodes */
Heap InitHeap(int maxsize);


/* Debug, added by Yiming */
int  GetHeapNum(Heap hp);

/* delete a heap data structure */
void FreeHeap(Heap hp);

/* add the element to the heap */
void AddHeap(Heap hp, HeapData data, HeapKey key); 

/* return top of the heap, without removing it from heap (FALSE if empty) */
boolean TopHeap(Heap hp, HeapData *data, HeapKey *key);

/* replace the heap's top item with a new item, and reheap */
void RepHeap(Heap hp, HeapData data, HeapKey key);

/* remove the heap's top item, if any (FALSE if empty heap) */
boolean RemHeap(Heap hp, HeapData *data, HeapKey *key);

/* remove the item that has matching data from the heap, 
   if any (FALSE if empty heap), the data is not returned */
boolean RemHeapItem(Heap hp, HeapData *data, HeapKey *key);



#ifdef __cplusplus
}
#endif 


#endif
