/* @TITLE "diskdevice.c: Simulate a disk device"*/
/* 
 * diskdevice - this file just includes the appropriate diskdevice-*.c,
 *   depending on the configuration flags. 
 *
 * exported functions:
 *   DiskDeviceInit
 *   DiskDeviceDone
 *   DiskDeviceTransfer
 *   DiskDeviceStart
 *   DiskDeviceFinish
 *   DiskDeviceSync
 *   DiskDeviceShape
 *
 * David Kotz 1994
 */

/* $Id: diskdevice.c,v 2.0 94/07/17 18:34:25 dfk Exp $ */

#include "diskmodel.param"

/* for EV_DISKSTATE events */
#define DISKSTATE_IDLE 0
#define DISKSTATE_CONTROL 1
#define DISKSTATE_MOVE 2
#define DISKSTATE_XFER 3

/* for EV_BUSSTATE events */
#define BUSSTATE_IDLE 0
#define BUSSTATE_GRAB  1
#define BUSSTATE_COMMAND  2
#define BUSSTATE_DATA  3

#ifdef MODEL_DISK
# include "diskdevice-model.c"
#endif

#ifdef TRIVIAL_DISK
# include "diskdevice-trivial.c"
#endif 
