/* 
 *  @TITLE "modularize.h"
 *
 *  This file is supposed to include all the typedefs, macros
 *  and function headers that allows diskdevice.c to compile
 *  independently of proteus.
 *
 */
/* $Id: modularize.h,v 2.0 94/07/17 18:34:55 dfk Exp $ */

#ifndef MODULARIZE_H
#define MODULARIZE_H

#ifdef __cplusplus
extern "C" {
#endif 


/* ---- including header files ---- */
#include <stdio.h>
#include <math.h>  
#include <sys/types.h>
#include <sys/stat.h>
#include <sys/file.h>
#include <malloc.h>
#include <unistd.h>
#include <stdlib.h>
/*#include <string.h> */
#include <time.h>

/* ---- constant declarations ---- */
#define TRUE        1
#define FALSE       0
#define ERROR      -1		/* misc error */
#define FATAL      -9		/* fatal error */


/* ----global variables ---- */
/* none */

/* ---- macros for debugging ---- */

#define DEBUG1 if (1)
#define DEBUG0 if (0)

/* ---- typedef for function pointer to functions that returns void ---- */
typedef void (*FuncPtr)();

/* ======================================================================= */
/* Redefinition of the macros or constants previously available in
   porteus main program. */
#define PRIVATE static
#define ulong unsigned long
#define CYCLE_COUNTING_OFF
#define CYCLE_COUNTING_ON

#define INVARIANT2(a,b)   {if (!(a)) {fprintf(stderr, b); exit(-1);}}
#define INVARIANT3(a,b,c)   {if (!(a)) {fprintf(stderr, b, c); exit(-1);}}
#define INVARIANT4(a,b,c,d)   {if (!(a)) {fprintf(stderr, b, c, d); exit(-1);}}
#define TICSperMSEC  25000.0	/* assuming 25MHz */
#define MSECperTIC  (1/25000.0)	/* assuming 25MHz */
#define UlongAbsDiff(a,b)  ((a) >(b)? ((a)-(b)):((b)-(a)))
#define define_local(a, b, c) (*(a) = (b))

/* though only consists of 0 and 1 */
typedef int boolean;

/* definition for TICS */

#ifdef LONG_LONG_TIME
typedef unsigned long long TICS;
#else
typedef unsigned long TICS;
#endif

#ifdef LONG_LONG_TIME
# define MAXTIME (TICS)(0xffffffffffffffffLL)
#else
# define MAXTIME (TICS)(0xffffffffL)
#endif
#define NEVER MAXTIME

/* Redefinition of functions in the timing module */
TICS InitTime(void);
TICS GetTime(void);
TICS max(TICS one, TICS two);
TICS min(TICS one, TICS two);
void WaitTime(TICS);
void WaitDuration(TICS);
char* time_print(TICS t);
char* timep_print(TICS *t);




/* ======================================================================= */
/* this is the global structure that contains information about time */
typedef struct timestruct
{
  TICS currenttime;
} timestruct;

/* this is to be used by the event manager */
void thread_suspend(int tid); 



#define MY_TID     disk           /* just a dummy used as a thread ID */
#define MY_STID    disk           /* another dummy */


/* ---------------- for REQUEST() only ------------------- */

/* maximum heap size */
#define HEAP_MAX  20

#define CURR_PROCESSOR 5	/* dummy */

#define NO_OF_DISKS 1000      /* plenty */

#define INDEX_EVENT(a,b,c)      {}
#define INDEX_TIME_EVENT(a,b,c,d) {}
#define SUM_ARRAY_METRIC(a, b, c) {}
#define AVG_ARRAY_METRIC(a,b,c)   {}
#define STDDEV_ARRAY_METRIC(a,b,c,d) {}

typedef char *UserData;  



/*------------------------------------------------------
 *
 *    User Event Process
 *
 *------------------------------------------------------
 */

#define USER_EVENT        0x1000
#define EVENT_DISKDONE    0x1001
#define EVENT_QUIT        0xffff



typedef boolean (*tEventProcedure)(int disk, int EventCode, TICS now);

extern tEventProcedure RegisterUserEventProcedure(tEventProcedure UserProcedure);

extern boolean ProcessAllEvents(void);

void  ScheduleEvent(int disk, int event, TICS eventTime);


#ifdef __cplusplus
}
#endif 


#endif                          /* only include this file if it is not
				   previously included */
