#ifndef DISKMODEL_H
#define DISKMODEL_H

/*****************************************************************************
 *                                                                           *
 *      File Name:        diskmodel.H                                        *
 *                                                                           *
 *      Author:           Yiming Hu                                          *
 *                        hu@ele.uri.edu                                     *
 *                        Department of Electrical & Computer Engineering    *
 *                        University of Rhode Island                         *
 *                        Kingston, RI 02881                                 *
 *                                                                           *
 *****************************************************************************/


//Do not change the next line. It is for SCCS version control
//SCCS  @(#)diskqueue.c V3.2    02/07/97  (in DCD Simulator) (C) Yiming Hu


#include <stdio.h>
#include <string.h>

#include "general.H"
#include "diskqueue.H"

#include "queue.h"
#include "heap.h"
#include "diskdevice.h"

#define MAX_REQUEST 1024

class tUserEventHandler
{
  private:
    static tUserEventHandler *HandlerPointer;
    static boolean  theHandler(int disk, int EventCode, TICS now);
    tEventProcedure DefaultHandler;
  public:
    void    init(void);
    virtual boolean Handler(int disk, int EventCode, TICS now);
    boolean topHeap(HeapData *data, TICS *Time);
    int     getHeapNum();
};


//--------------------------------------------------------
//   A abstract SCSI disk
//--------------------------------------------------------
class   tAbstractDisk
{
  public:
    tAbstractDisk(const char* Name = NULL) { setName(Name); }; 

    const char*     getName(void) const { return (const char*) sName; };
    virtual void    sendRequest(tRequestPacket *Request) = 0;
    virtual void    endRequest(void) = 0;
    virtual BOOLEAN bIsBusy(void) = 0;
    virtual void    done(void) = 0;
    virtual void    sync(void) = 0;
    virtual boolean bImmediateReport(void) {return ::bImmediateReportDisk();};

  private:
    enum { MAX_NAME_LENGTH = 80 };   		// A kludge to limit the name scope

  protected:
    int     DiskID;
    char    sName[MAX_NAME_LENGTH];             // Device Name

    void    setName(const char* Name = NULL)
            { if ( Name == NULL ) 
                 strncpy( sName, "UnInit", MAX_NAME_LENGTH );
              else 
                 strncpy( sName, Name, MAX_NAME_LENGTH );
            }
};





//--------------------------------------------------------
//   A standard SCSI disk 
//--------------------------------------------------------
class   tDisk : public tAbstractDisk
{
private:
    // Static member, keep it in the first to make sure
    // that it will be initialized first. It is for 
    // generating DiskID used in the diskdevice-model.c. 
    // It is incremented by the constructors
    static  int NextDiskID;

    // Copies of information in the request packet
    // these values will be returned to the called when the access is finished
    tRequestPacket   CurrentRequest;

    int    TotalReadNumber;         // Statistics numbers
    int    TotalWriteNumber; 

    tDisk(void);            // No default ctor is allowed

public:
    tDisk(char *Name);
    tDisk(char *Name, int busId, char *diskFileName);

    tDisk(char *Name, int busId, int *busOwner,
          NCQUEUE *busWaitq, char *diskFileName);

    void            init(int busId, int *busOwner, NCQUEUE *busWaitq, char *diskFileName);

    // Interface
    virtual void    sendRequest(tRequestPacket *Request);
    virtual void    endRequest(void);
    virtual BOOLEAN bIsBusy(void);
    virtual void    done(void);
    virtual void    sync(void);

    virtual void    deviceShape(ulong *nSectors, ulong *sectorSize,
                                ulong *nTracks, ulong *sectorsPerTrack) const;
    virtual void    getAccessNumber(int& TotalRead, int& TotalWrite) const;
};




//--------------------------------------------------------
//    A SCSI disk with a request queue
//--------------------------------------------------------
class   tQueuedDisk : public tDisk
{
private:
    tDiskQueue Queue;

public:
    //constructor
    tQueuedDisk(char *Name);
    tQueuedDisk(char *Name, int busId, char *diskFileName);
    tQueuedDisk(char *Name, int busId, int *busOwner,
                NCQUEUE *busWaitq, char *diskFileName);

    // Interface
    virtual void    sendRequest(tRequestPacket *Request);
    virtual void    endRequest(void);
    virtual BOOLEAN bIsBusy(void);
};



#endif /* DISKMODEL_H */
