/*****************************************************************************
 *                                                                           *
 *      File Name:        diskqueue.C                                        *
 *                                                                           *
 *      Function:         Defines the queue class which is a first-in-       *
 *                        first-out queue. The contents of the queue         *
 *                        are disk request packages.                         *
 *                                                                           *
 *      Author:           Yiming Hu                                          *
 *                        hu@ele.uri.edu                                     *
 *                        Department of Electrical & Computer Engineering    *
 *                        University of Rhode Island                         *
 *                        Kingston, RI 02881                                 *
 *                                                                           *
 *****************************************************************************/


//Do not change next line. It is for SCCS version control
//SCCS  @(#)diskqueue.c	V3.2    02/07/97  (in DCD Simulator) (C) Yiming Hu


#include <iostream.h>
#include <stdlib.h>

#include "diskqueue.H"


tDiskQueue::tDiskQueue(void)
{
    Init();
}


void 
tDiskQueue::Init(void)
{
    nQueueStart = 0;
    nQueueEnd   = 0;

    MaxLength      = 0;
    CurrentLength  = 0;
    AverageTotal   = 0;
    TotalAccessNum = 0;
}


int
tDiskQueue::currentLength() const
{
    return CurrentLength;
}


BOOLEAN 
tDiskQueue::bIsEmpty(void) const
{
    if (nQueueStart == nQueueEnd )
       return TRUE;
    else
       return FALSE;
}


void 
tDiskQueue::In(const tRequestPacket *Item)
{
    int nDiff = (nQueueEnd - nQueueStart);
  
    if ((-1 == nDiff) || (MAX_QUEUE_SIZE == nDiff)) {
       cerr << "Disk Queue is full!\n";
       exit(FATAL);
    }

    DiskQueue[(nQueueEnd)++] = *Item;
    if (nQueueEnd >= MAX_QUEUE_SIZE) 
        nQueueEnd = 0; 

    CurrentLength++;
    if ( CurrentLength > MaxLength ) {
        MaxLength = CurrentLength;
    }
    TotalAccessNum++;
    AverageTotal += CurrentLength;
}


void 
tDiskQueue::Out(tRequestPacket * Item)
{
    if (nQueueEnd == nQueueStart) {
       cerr << "Disk Queue is empty!\n";
       exit(FATAL);
    }
  
    *Item = DiskQueue[(nQueueStart)++];
    if (nQueueStart >= MAX_QUEUE_SIZE)  
        nQueueStart = 0;

    CurrentLength--;
}


BOOLEAN 
tDiskQueue::TestTop(tRequestPacket* Item) const
{
   if (nQueueStart == nQueueEnd) {
       return FALSE;
   } else {
       *Item = DiskQueue[nQueueStart];
       return TRUE;
   }
}



void
tDiskQueue::getQueueLength(double& Average, int& Max) const
{
    if ( TotalAccessNum == 0 ) {
       Average = 0;
    } else {
       Average = AverageTotal / TotalAccessNum;
    }

    Max     = MaxLength;
}

