/************************************************************************ 

     This program is used to demonstrate the C++ interface
     of the modified simulator. A single disk is simulated.
     The program sequentially gets a request from the 
     trace file, sends it to the disk, waits until it finishes, 
     and sends the next one.  The results should be the same as 
     that of "test1.c" program provided with the original simulator.

     The time interval information is ignored in this program but used
     in the "test2disk" program.

     To run the program, type
          test1disk input1.dat

     Author:           Yiming Hu                                         
                       hu@ele.uri.edu                                 
                       Department of Electrical & Computer Engineering
                       University of Rhode Island                    
                       Kingston, RI 02881                           

**************************************************************************/

//Do not change the next line. It is for SCCS version control
//SCCS  @(#)diskqueue.c V3.2    02/07/97  (in DCD Simulator) (C) Yiming Hu


#include <stream.h>
#include <iostream.h>
#include <iomanip.h>
#include <string.h>

#include "diskmodel.H"
#include "tracedata.H"
#include "general.H"


//--------------------------------------------------------
//  Constants 
//--------------------------------------------------------

const int    EVENT_SENDREQUEST = 0x2000;

const double MSECperUSEC  =   ( 1.0 / 1000.0 );
const double TICSperUSEC  =   (TICSperMSEC * MSECperUSEC);


//--------------------------------------------------------
//  Global data
//--------------------------------------------------------

void SendNextRequest();

tDisk Disk( "Disk1", 0, NULL );

tRequestPacket Request;



//--------------------------------------------------------
//  User event handler
//--------------------------------------------------------
class tMyUserEventHandler : public tUserEventHandler
{
    virtual boolean Handler(int disk, int EventCode, TICS now)
    {
        // Important! You must call the base function to handle the events 
        boolean ReturnCode = tUserEventHandler::Handler( disk, EventCode, now );

        // Put your own code here to handle newly defined user events
        switch ( EventCode ) {
            case EVENT_SENDREQUEST:
                 SendNextRequest();
                 return FALSE;
            case EVENT_DISKDONE:
                 // Current request finishes, let's send the next request
                 ScheduleEvent( disk, EVENT_SENDREQUEST, GetTime() );
                 return FALSE;
            default:
                 break;
        }
        return ReturnCode;
    }

};


tMyUserEventHandler MyEventHandler;



//--------------------------------------------------------
//  main program
//--------------------------------------------------------
int 
main(int argc, char **argv)
{

    // can only take 1 parameter 
    if ( argc != 2 ) {
        cerr << "syntax: " << argv[0] << "testinput\n";
        exit(FATAL);
    }

    MyEventHandler.init();

    OpenTraceData( argv[1] );

    // The First Push of the event system 
    ScheduleEvent(0, EVENT_SENDREQUEST, GetTime());

    // The event loop
    while ( 1 ) {
       ProcessAllEvents();
    }
}



// Callback function : when a request finishes, this function 
// will be called. We can report the timing information here.
void CallBack(struct tRequestPacket DiskReturnData)
{
    TICS StartTime = (TICS)(DiskReturnData.RequestTime/TICSperUSEC);
    TICS StopTime  = (TICS)(DiskReturnData.FinishTime/TICSperUSEC);

    cout << "  Req No."   << setw(3) << DiskReturnData.RequestNo
         << "  LBA = "    << setw(7) << DiskReturnData.LBA
         << "  Start at " << setw(6)  << time_print( StartTime )
         << "  Finish at " << setw(6) << time_print( StopTime )
         << "  Response time = "  << time_print( StopTime - StartTime )
         << endl;
}



void SendNextRequest()
{
    /* Read the source trace file till the end of file */
    if ( ! bGetTraceData( &Request ) ) {

       /* Done with the trace, reset the info and shut it down */
       Disk.sync();  
       Disk.done();  
  
       exit( 0 );
    }

    Request.CallBack    = CallBack;
    Request.RequestTime = GetTime();

    Disk.sendRequest( &Request );
}

