/* Agent Tcl
   Bob Gray
   15 July 1995

   tclAgentInt.h

   This file defines the internal routines that are called from more than
   one source file.

   Copyright (c) 1995, Robert S. Gray Dartmouth College

   See the file "agent.terms" for information on usage and redistribution
   of this file and for a DISCLAIMER OF ALL WARRANTIES.
*/

#ifndef _TCL_AGENT_INT_H
#define _TCL_AGENT_INT_H

#include "tcl.h"
#include "tclAgent.h"

  /* Tcl commands */

int Agent_CryptCmd
	(ClientData dummy, Tcl_Interp *interp, int argc, char **argv);

int Agent_SelectCmd
	(ClientData dummy, Tcl_Interp *interp, int argc, char **argv);

int Agent_TransferCmd
	(ClientData dummy, Tcl_Interp *interp, int argc, char **argv);

int Agent_BeginCmd   
	(ClientData dummy, Tcl_Interp *interp, int argc, char **argv);

int Agent_NameCmd    
	(ClientData dummy, Tcl_Interp *interp, int argc, char **argv);

int Agent_EndCmd     
	(ClientData dummy, Tcl_Interp *interp, int argc, char **argv);

int Agent_SendCmd    
	(ClientData dummy, Tcl_Interp *interp, int argc, char **argv);

int Agent_ReceiveCmd 
	(ClientData dummy, Tcl_Interp *interp, int argc, char **argv); 

int Agent_DiskCmd
	(ClientData dummy, Tcl_Interp *interp, int argc, char **argv);

int Agent_JumpCmd    
	(ClientData dummy, Tcl_Interp *interp, int argc, char **argv);

int Agent_ForkCmd    
	(ClientData dummy, Tcl_Interp *interp, int argc, char **argv);

int Agent_SubmitCmd  
	(ClientData dummy, Tcl_Interp *interp, int argc, char **argv);

int Agent_VersionCmd 
	(ClientData dummy, Tcl_Interp *interp, int argc, char **argv);

int Agent_ReqCmd     
	(ClientData dummy, Tcl_Interp *interp, int argc, char **argv);

int Agent_GetReqCmd  
	(ClientData dummy, Tcl_Interp *interp, int argc, char **argv);

int Agent_RootCmd    
	(ClientData dummy, Tcl_Interp *interp, int argc, char **argv);

int Agent_ForceCmd 
	(ClientData dummy, Tcl_Interp *interp, int argc, char **argv);

int Agent_SleepCmd
	(ClientData dummy, Tcl_Interp *interp, int argc, char **argv);

int Agent_ElapsedCmd
	(ClientData dummy, Tcl_Interp *interp, int argc, char **argv);

int Agent_ExitCmd
	(ClientData dummy, Tcl_Interp *interp, int argc, char **argv);

int Agent_MaskCmd
	(ClientData dummy, Tcl_Interp *interp, int argc, char **argv);

int Agent_EventCmd
	(ClientData dummy, Tcl_Interp *interp, int argc, char **argv);

int Agent_GetEventCmd
	(ClientData dummy, Tcl_Interp *interp, int argc, char **argv);

int Agent_InfoCmd
	(ClientData dummy, Tcl_Interp *interp, int argc, char **argv);
	
  /* library routines with no checks */
  
AGENT_ID *agentForceBegin 
	(Tcl_Interp *interp, double seconds, MACHINE_ID *actual, MACHINE_ID *dest);

int agentForceEnd
	(Tcl_Interp *interp, double seconds, AGENT_ID *id, AGENT_ID **forcedId, UINT_8 end_type);
  
#endif  
