/* Agent Tcl
   Bob Gray
   12 February 1995

   This file implements the Agent_AppInit procedure and "main".

   Copyright (c) 1995, Robert S. Gray Dartmouth College

   See the file "agent.terms" for information on usage and redistribution
   of this file and for a DISCLAIMER OF ALL WARRANTIES.
*/

#include "tcl.h"
#include "tclAgent.h"
#include "tclRestrict.h"
#include "tclTcpip.h"
#include "truefalse.h"

/* Agent_AppInit

   Purpose: Initialize an Agent Tcl interpreter

     Input: interp = the current interpreter
            server = TRUE if the agent has arrived via the server

    Output: The procedure returns TCL_OK on successful initializatio and
            TCL_ERROR otherwise.
*/

int Agent_AppInit (Tcl_Interp *interp, int server)
{
    /* core */

  if (Tcl_Init(interp) == TCL_ERROR) {
    return TCL_ERROR;
  }

    /* TCP/IP */

  if (Tcpip_Init(interp) == TCL_ERROR) {
    return TCL_ERROR;
  }

    /* restrictions */

  if (Restrict_Init(interp) == TCL_ERROR) {
    return TCL_ERROR;
  }

    /* agents */

  if (Agent_Init(interp, LANGUAGE_NAME, server) == TCL_ERROR) { 
    return TCL_ERROR;
  }

    /* user specific startup file if we have NOT arrived via the server */

  if (!server) {
    tcl_RcFileName = "~/.tclshrc";
  }

  return TCL_OK;
}

int main (int argc, char **argv)
{
  Agent_Main (argc, argv, Agent_AppInit);
  return 1;
}
