/* Agent Tcl
   Bob Gray
   Xiyong Song
   5 November 1995

   tclCryptCmd.cc

   This file provides an interface to DES encryption.

   Copyright (c) 1995, Robert S. Gray, Xijong Song, Dartmouth College

   See the file "agent.terms" for information on usage and redistribution
   of this file and for a DISCLAIMER OF ALL WARRANTIES.
*/

#include <sys/types.h>
#include <stdio.h>
#include <stdlib.h>
#ifdef SYSV
#include <crypt.h>
#endif
#ifndef COSMO
#include <unistd.h>
#else
#include </usr/local/lib/gcc-lib/rs6000-ibm-aix3.2.5/2.6.3/include/unistd.h>
#endif
#include "tcl.h"
#include "tclAgent.h"
#include "tclAgentInt.h"

/* Tcl_CryptCmd

   Tcl syntax: crypt <key> <salt>

      Purpose: Use <key> to encrypt a constant string (<salt> is used to
               seed the DES encryption algorithm).  Returns the encrypted
               version of the constant string.

        Input: dummy  = client data (unused)
               interp = the current interpreter
               argc   = the number of command arguments
               argv   = the command arguments

       Output: The procedure returns TCL_ERROR and sets the interpreter result
               to an appropriate error message on error.  Otherwise the
               procedure returns TCL_OK and sets the interpreter result to
               the encrypted constant string.
*/

int Agent_CryptCmd (ClientData dummy, Tcl_Interp *interp, int argc, char **argv)
{
  char *string;

    /* check the number of command arguments */

  if (argc != 3) {
    Tcl_AppendResult (interp, "wrong # of args: should be \"", argv[0], " <key> <salt>\"", (char *) NULL);
    return TCL_ERROR;
  }

    /* encrypt the constant string */

  if ((string = crypt (argv[1], argv[2])) == NULL) {
    Tcl_AppendResult (interp, "DES encryption failed", (char *) NULL);
    return TCL_ERROR;
  }

    /* put encrypted constant string into the interpreter result */

  Tcl_SetResult (interp, string, TCL_VOLATILE);
  return TCL_OK;
}
