/* Agent Tcl
   Bob Gray
   15 February 1995

   tclLocation.h

   This file defines the internal routines that keep track of agent locations.

   Copyright (c) 1995, Robert S. Gray Dartmouth College

   See the file "agent.terms" for information on usage and redistribution
   of this file and for a DISCLAIMER OF ALL WARRANTIES.
*/

#ifndef _TCL_AGENT_LOCATION_H
#define _TCL_AGENT_LOCATION_H

#include <sys/times.h>
#include "map.h"
#include "tcl.h"
#include "tclAgent.h"

  /* root and not root */

const AGENT_NOT_ROOT	   = 0;
const AGENT_ROOT           = 1;

  /* registered and not registered */

const AGENT_NOT_REGISTERED = 0;
const AGENT_REGISTERED     = 1;

  /* agent location */

class AGENT_LOCATION
{
      /* map interpreter address to the corresponding AGENT_LOCATION */
      /* structures                                                  */

    static POINTER_MAP *interp_map;

      /* refresh one element of the agent array */

    void refresh_id_var (char *name, char *string);

  public:

    Tcl_Interp *interp; /* interpreter associated with this instance          */
    int server;         /* TRUE if the agent arrived via the server           */
    int toplevel;       /* TRUE if the agent is a root agent                  */
    int registered;     /* TRUE if the agent has been registered              */
    int modified;       /* TRUE if modification is allowed                    */
    MACHINE_ID *actual; /* actual agent location                              */
    AGENT_ID *root;     /* root identification                                */
    AGENT_ID *local;    /* local identification                               */
    clock_t startTime;  /* time at which the agent started on current machine */
    char *language;     /* symbolic name of the language                      */

      /* constructor and destructor */

    AGENT_LOCATION (Tcl_Interp *interp, char *actual_host, UINT_32 actual_ip, char *language, int server);
    ~AGENT_LOCATION ();

      /* reload the location information and refresh the Tcl "agent" array */

    void reload (AGENT_ID *new_root, AGENT_ID *new_local, int new_registered, int new_toplevel);
    void refresh (void);

      /* get the location structure associated with an interpreter */

    static AGENT_LOCATION *get_location (Tcl_Interp *interp); 
};

#endif
