/* Agent Tcl
   Bob Gray
   4 October 1995

   tkAgent.h

   This file defines the agent-tk library routines.
*/

#ifndef _TK_AGENT_H
#define _TK_AGENT_H

#ifdef __cplusplus
#define EXTERN extern "C"
#else
#define EXTERN extern
#endif

  /* Tk command-line options */

struct TK_OPTIONS
{
  char *name;        /* name of the application                        */
  char *display;     /* name of the display                            */
  char *geometry;    /* initial window geometry                        */
  int synchronize;   /* 1 if using synchronous mode for display server */

#ifdef __cplusplus
  TK_OPTIONS (void);
#endif
};

  /* initialization procedure type */

typedef int (AgentTk_AppInitProc)
	(Tcl_Interp *interp, int server, TK_OPTIONS *options)
;
  /* initialization and main */

EXTERN int AgentTk_Init 
	(Tcl_Interp *interp, TK_OPTIONS *options);

EXTERN void AgentTk_Main 
	(int argc, char **argv, AgentTk_AppInitProc *appInitProc);

#endif
