/* Agent Tcl
   Bob Gray
   4 October 1995

   tkAgentInt.h

   This file defines the agent-tk internal routines.
*/

#ifndef _TK_AGENT_INT_H
#define _TK_AGENT_INT_H

#include "map.h"
#include "my_alloc.h"
#include "my_strings.h"
#include "tcl.h"
#include "tkAgent.h"

  /* Tcl commands */

int AgentTk_ExitCmd
	(ClientData clientData, Tcl_Interp *interp, int argc, char **argv);

int AgentTk_LoopCmd
	(ClientData clientData, Tcl_Interp *interp, int argc, char **argv);

int AgentTk_MainCmd
	(ClientData clientData, Tcl_Interp *interp, int argc, char **argv);

  /* information about the main window */

struct MAIN_WINDOW
{
    /* map interpreter addresses to MAIN_WINDOW address */

  static POINTER_MAP *interpMap; 
  static MAIN_WINDOW *get_main (Tcl_Interp *interp);

    /* data */

  Tcl_Interp *mainInterp;  /* interpreter associated with this instance */
  
    /* Tk options */

  char *display;       /* name of the display                            */
  char *name;          /* name of the application                        */
  char *geometry;      /* initial geometry                               */
  int synchronize;     /* 1 if using synchronous mode for display server */ 

    /* update the options */

  void update (TK_OPTIONS *options);

    /* constructor and destructor */

  MAIN_WINDOW (Tcl_Interp *interp, TK_OPTIONS *options);
 ~MAIN_WINDOW ();
};    
 
#endif
