/* Agent Tcl
   Bob Gray
   2 October 1995
  
   This file implements the Agent_AppInit procedure and "main".
 
   Copyright (c) 1995, Robert S. Gray Dartmouth College

   See the file "agent.terms" for information on usage and redistribution
   of this file and for a DISCLAIMER OF ALL WARRANTIES.
*/

#include "tcl.h"
#include "tk.h"
#include "agentId.h"
#include "tclAgent.h"
#include "tkAgent.h"
#include "tclRestrict.h"
#include "tclTcpip.h"
#include "truefalse.h"

int AgentTk_AppInit (Tcl_Interp *interp, int server, TK_OPTIONS *options)
{
    /* core */

  if (Tcl_Init(interp) != TCL_OK) {
    return TCL_ERROR;
  }

    /* Tk events */

  if (Tk_EventInit(interp) != TCL_OK) {
    return TCL_ERROR;
  }

    /* TCP/IP */

  if (Tcpip_Init(interp) != TCL_OK) {
    return TCL_ERROR;
  }
     
    /* restrictions */

  if (Restrict_Init(interp) != TCL_OK) {
    return TCL_ERROR;
  }
  
    /* agents */

  if (Agent_Init (interp, LANGUAGE_NAME, server) != TCL_OK) {
    return TCL_ERROR;
  }

    /* tk agents */

  if (AgentTk_Init (interp, options) != TCL_OK) {
    return TCL_ERROR;
  }

    /* user-specific intialization file if we have NOT arrived via the server */

  if (!server) {
    tcl_RcFileName = "~/.wishrc";
  }

  return TCL_OK;
}

int main (int argc, char **argv)
{
  AgentTk_Main (argc, argv, AgentTk_AppInit);
  return 0;		
}
