/* Agent Tcl
   Bob Gray
   7 October 1995

   tkBasic.cc

   This file implements the library routines for Agent Tk.
*/

#include "map.h"
#include "my_alloc.h"
#include "tkAgentInt.h"

  /* pointer map in class MAIN_WINDOW */

POINTER_MAP *MAIN_WINDOW::interpMap = NULL;

  /* get the MAIN_WINDOW structure associated with an interpreter */

MAIN_WINDOW *MAIN_WINDOW::get_main (Tcl_Interp *interp) {
  return ((MAIN_WINDOW *) interpMap -> lookup ((void *) interp));
}

/* TK_OPTIONS::TK_OPTIONS

   Purpose: This procedures is the constructor for class TK_OPTIONS.
*/

TK_OPTIONS::TK_OPTIONS (void)
{
  name        = NULL;
  display     = NULL;
  geometry    = NULL;
  synchronize = 0;
}

/* MAIN_WINDOW::MAIN_WINDOW and MAIN_WINDOW::~MAIN_WINDOW

   Purpose: These procedures are the constructors and destructors for
            class MAIN_WINDOW.

     Input: interp  = the current interpreter
            options = Tk options
*/

MAIN_WINDOW::MAIN_WINDOW (Tcl_Interp *interp, TK_OPTIONS *options)
{
    /* initialize the data */

  mainInterp  = interp;

  if (options == NULL) {
    display     = NULL;
    geometry    = NULL;
    name        = NULL;
    synchronize = 1;
  } else {
    display     = my_strcpy (options -> display);
    geometry    = my_strcpy (options -> geometry);
    name        = my_strcpy (options -> name);
    synchronize = options -> synchronize;
  }

    /* can not have a NULL name */

  if (name == NULL) {
    name = my_strcpy ("unnamed");
  }

    /* add the interpreter to the map -- first creating if necessary */

  interpMap -> add ((void *) interp, (void *) this);
}

MAIN_WINDOW::~MAIN_WINDOW ()
{
    /* delete the data */

  delete_check (display);
  delete_check (geometry);
  delete_check (name);

    /* remove the interpreter from the map */

  interpMap -> remove ((void *) mainInterp);
}

/* MAIN_WINDOW::update

   Purpose: This procedure updates the Tk options.

     Input: options = the Tk options (NULL or 0 means that the old option
                      value should be retained)

    Output: The procedure update the Tk options.
*/

void MAIN_WINDOW::update (TK_OPTIONS *options)
{
  if (options -> name != NULL) {
    delete_check (name);
    name = my_strcpy (options -> name);
  }  

  if (options -> display != NULL) {
    delete_check (display);
    display = my_strcpy (options -> display);
  }

  if (options -> geometry != NULL) {
    delete_check (geometry);
    geometry = my_strcpy (options -> geometry);
  }

  if (options -> synchronize != 0) {
    synchronize = options -> synchronize;
  }
} 
