#!/usr/contrib/bin/agent

set directories "tcl7.4_stack \
		utility \
		tcpip-tcl \
		agent-tcl \
		server \
		scripts/agent \
		scripts/tk \
		restrict \
		tk4.0 \
		agent-tk"

set home [pwd]

set sum 0

puts "" 
puts [format "%20s   %6s" "Directory" "Lines"]
puts [format "%20s   %6s" "=============" "======"]

proc ls pattern {
  if {[catch {glob $pattern} result]} {
    return ""
  } else {
    return $result
  }
}

foreach d $directories {

    # change into the directory 

  cd $d

    # get the list of files

  set files "[ls *.h] [ls *.c] [ls *.cc] [ls *.tcl]"
 
    # count the number of lines

  set count [eval "exec -noPipeError cat -n $files | tail -1"]
  puts [format "%20s   %6d" $d [lindex $count 0]]
  incr sum [lindex $count 0]
 
    # change back to the home directory

  cd $home
}

puts [format "%20s   %6s" "=============" "======"]
puts [format "%20s   %6s\n" "TOTAL" $sum]
