#!/usr/contrib/bin/agent
#
# client.tcl
#
# This is the "client_agent".  It uses agent_meet to establish a direct
# connection with the "server_agent" and exchange status information.  It
# assumes that the "server_agent" has the same controlling server.

  # register the agent on the current machine

if {[catch agent_begin]} {
  return -code error "ERROR: unable to register the agent on $agent(actual-server)"
}

if {[catch {

    # meet with the "server_agent"

  set sockfd [agent_meet "$agent(local-ip) server_agent"]

    # exchange status information

  tcpip_write $sockfd "Thank you for accepting the meeting!"
  set status [tcpip_read $sockfd -blocking]
  tcpip_close $sockfd

    # display the status information

  puts "$agent(local):\nThe server says ...\n$status"

} error_message]} then {

    # make sure that we clean up on error

  agent_end

  return -code error -errorcode $errorCode -errorinfo $errorInfo $error_message

} 

  # clean up
 
agent_end
