#!/usr/contrib/bin/agent
#
# client.tcl
#
# This is the "client_agent".  It uses agent_meet to establish a direct
# connection with the "server_agent" and exchange status information.  It
# assumes that the "server_agent" has the same controlling server.

  # register the agent on the current machine

if {[catch agent_begin]} {
  return -code error "ERROR: unable to register the agent on $agent(actual-server)"
}

if {[catch {

  # request a meeting 
  agent_req "$agent(local-ip) server_agent" -request

  # wait at most 10 seconds for the server to accept or reject the meeting
  set source [agent_getreq status meeting_port -time 15]

  if {$source == "-1"} {
      error "timeout while waiting for server response"
  }

  if {$status != "CONNECT"} {
      error "server has rejected the meeting"
  }

  set sockfd [tcpip_socket]
  tcpip_connect $sockfd $meeting_port

    # exchange status information

  tcpip_write $sockfd "Thank you for accepting the meeting!"
  set status [tcpip_read $sockfd -blocking]
  tcpip_close $sockfd

    # display the status information

  puts "$agent(local):\nThe server says ...\n$status"

} error_message]} then {

    # make sure that we clean up on error

  agent_end

  return -code error -errorcode $errorCode -errorinfo $errorInfo $error_message

} 

  # clean up
 
agent_end
