#!/usr/contrib/bin/agent

# Agent Tcl
# Bob Gray
# 29 October 1995
#
# disk.tcl
#
# This agent illustrates how to write a migrating agent to disk and then
# send it to the server at a later time.

proc indirect_jump {} {

  global agent

    # Save the current state of the agent to a file.  This state image is
    # sent to the server at a later time using agent_transfer.  When the 
    # state image is restored and the new agent begins executing, agent_disk
    # returns the string "JUMPED" in the new agent.
 
  set filename [agent_disk]

  if {$filename == "JUMPED"} {

      # I'm in the new agent.

    return HELLO

  } else {

      # I'm in the agent that called agent_jump.

    return $filename;
  }
}

  # register the agent

agent_begin

  # submit the indirect_jump procedure 

agent_submit $agent(local-ip) -procs indirect_jump -script indirect_jump

  # wait for indirect_jump to send the filename

agent_receive code filename -blocking

if {$code != 0} {
  return -code error "indirect jump failed"
}

  # display the filename

puts "The \"jump\" image has been stored in file $filename."

  # transfer the jump image to the server

puts "The \"jump\" image is being transferred to the server."
agent_transfer $agent(local-ip) $filename

  # wait for indirect_jump to send the HELLO

agent_receive code string -blocking

if {$code != 0} {
  return -code error "agent failed"
}

puts "The \"jumped\" agent says $string."

  # done

agent_end
