#!/usr/contrib/bin/agent
#
# email.tcl
#
# This is the "email_agent".  It uses agent_meet to establish a direct
# connection with the "file_agent" and exchange status information.  It
# assumes that the "file_agent" has the same controlling server.

  # register the agent on the current machine

if {[catch agent_begin]} {
  return -code error "ERROR: unable to register the agent on $agent(actual-server)"
}

if {[catch {

    # this is the "email_agent"

  agent_name email_agent

    # meet with the "file_agent"

  set sockfd [agent_meet "$agent(local-ip) file_agent"]

    # exchange status information

  tcpip_write $sockfd "{NEW_MESSAGES 0} {IN_BOX_MESSAGES 10}"
  set status [tcpip_read $sockfd -blocking]
  tcpip_close $sockfd

    # display the status information

  puts "$agent(local):\nThe file agent says ... $status\n"

} error_message]} then {

    # make sure that we clean up on error

  agent_end

  return -code error -errorcode $errorCode -errorinfo $errorInfo $error_message

} 

  # clean up
 
agent_end
