#!/usr/contrib/bin/agent
#
# file.tcl
#
# This is the "file_agent".  It uses agent_meet to establish a direct
# connection with the "email_agent" and exchange status information.  It
# assumes that the "email_agent" has the same controlling server.

  # register the agent on the current machine

if {[catch agent_begin]} {
  return -code error "ERROR: unable to register the agent on $agent(actual-server)"
}

if {[catch {
 
    # this is the "file_agent"

  agent_name file_agent

    # meet with the "email_agent"

  set sockfd [agent_meet "$agent(local-ip) email_agent"]

    # exchange status information

  tcpip_write $sockfd "{FREE_SPACE 65536 KB}"
  set status [tcpip_read $sockfd -blocking]
  tcpip_close $sockfd

    # display the status information

  puts "$agent(local):\nThe email agent says ... $status\n"

} error_message]} then {

    # did an error occur?

  agent_end

  return -code error -errorcode $errorCode -errorinfo $errorInfo $error_message

}

  # clean up

agent_end
