# Agent Tcl
# Bob Gray
# 22 October 1995
#
# hooks.tcl
#
# This file defines a hook for the agent_submit command.  agent_submit was
# chosen as an example since it requires the most complicated hook (all hooks
# must be submitted along with the script so that the hooks propagate to
# child agents).
#  
# This file is not a standalone script.  It should be sourced from inside
# another script.





##### hooked_commands ####

# hooked_commands contains the list of commands that have been redefined in
# order to add hooks.

uplevel #0 {set hooked_commands {}}





##### redefintion of agent_submit #####

# First we add agent_submit to the list of hooked procedures
# Then we redefine agent_submit.

uplevel #0 {lappend hooked_commands agent_submit}

proc agent_submit args {

  global errorCode errorInfo hooked_commands


  ##### Do arbitrary processing here! ######


    # We have to pass the variable "hooked_commands" and all of the commands
    # listed in "hooked_commands" to the remote machine so that the hooks will 
    # propragate to the child agent.  First we add the "hooked_commands" 
    # variable to the "-vars" part of the argument list.

  set index [lsearch -exact $args "-vars"]

  if {$index == -1} {
    lappend args "-vars" 
    set index [llength $args]
  } else {
    incr index
  }

  set args [linsert $args $index "hooked_commands"]

    # Then we add each redefined command to the "-procs" part of the argument
    # list.

  set index [lsearch -exact $args "-procs"]

  if {$index == -1} {
    lappend args "-procs"
    set index [llength $args]
  } else {
    incr index
  }

  foreach n $hooked_commands {
    set args [linsert $args $index $n]
  }

    # Do the standard agent_submit using the internal name "_agent_submit".

  set code [
    catch {
      uplevel "_agent_submit $args"
    } result  
  ]


  ##### Do arbitrary processing here! #####


    # Propagate errors back correctly.

  if {$code != 0} {
    return -code $code -errorcode $errorCode -errorinfo $errorInfo $result
  } else {
    return $result
  }
} 
