#!/usr/contrib/bin/agent
#
# Agent Tcl
# Bob Gray
# 25 October 1995
#
# machine.tcl (CS version)
#
# Description:
#
# This agent checks if the server is running on one or more machines.
#
# Usage:
#
# machine.tcl [ all | name [ name ... ]]
#
# If there are  no arguments, the agent prints the list of machines on which 
# the server should be running.  If the first argument is "all", the agent
# checks that the server is running on all of the machines.  Otherwise
# the agent checks that the server is running on the machines listed as
# arguments.

  # list of machines -- make sure that you replace these with your machines

set machines "bald.cs.dartmouth.edu \
	      muir.cs.dartmouth.edu \
	      tuolomne.cs.dartmouth.edu \
	      tenaya.cs.dartmouth.edu \
	      tioga.cs.dartmouth.edu \
	      m.cs.dartmouth.edu \
	      oddjob.cs.dartmouth.edu \
	      jaws.cs.dartmouth.edu \
	      q.cs.dartmouth.edu \
	      felix.cs.dartmouth.edu \
	      gogol.cs.dartmouth.edu \
	      spectre.cs.dartmouth.edu \
	      sable.cs.dartmouth.edu \
	      plum.cs.dartmouth.edu \
	      gainsboro.cs.dartmouth.edu \
	      orchid.cs.dartmouth.edu \
	      coral.cs.dartmouth.edu \
	      peach.cs.dartmouth.edu \
	      salmon.cs.dartmouth.edu"

  # no arguments means to just print the list of machines

if {$argc == 0} {

  set machines [lsort $machines]

  puts "\nAgent Tcl server should be running on ...\n"

  foreach m $machines {
    puts $m
  }

  puts ""
  exit
}

  # explicitly check each machine

if {[lindex $argv 0] != "all"} {
  set machines $argv
}

  # register the agent

if {[catch {agent_begin}]} {
  return -code error "ERROR: unable to register the agent on $agent(actual-server)"
}

  # submit the test agents

puts "\nSubmitting the agents:\n"

set submitted 0
set errors 0
 
set script {
  set id [
    agent_submit $m -time 10.0 -script {return HELLO}
  ]
}

foreach m $machines {

  puts -nonewline stdout "$m ... "
  flush stdout

  if {[catch $script result]} {
    puts "FAILED"
    incr errors
    set error($m) $result
  } else {
    puts "OKAY"
    incr submitted
    set response([lindex $id 0]) 0
  }
}

  # wait for the responses

set received 0
set xerrors 0

if {$submitted > 0} {

  puts "\nWaiting for results:\n"
  
  for {set i 1} {$i <= $submitted} {incr i} {

    set source [agent_receive code string -time 15.0]

    if {$source == "-1"} {
      puts "TIMEOUT"
      break;
    }

    incr received
    set machine [lindex $source 0]
    set response($machine) 1

    if {$code == 1} {
      set xerror([lindex $source 0]) $string
      incr xerrors
      puts "$machine ... FAILED"
    } else {
      puts "$machine ... OKAY"
    }
  }  
}

  # output any error conditions

set any_error 0

puts "\n**** ERRORS ****"

if {$errors != 0} {

  set any_error 1

  puts "\nUnable to submit to the following machines:\n"

  foreach m [array names error] {
    puts "$m ($error($m))"
  } 
}

if {$received != $submitted} {

  set any_error 1
  
  puts "\nNo response from the following machines:\n"

  foreach m [array names response] {
    if {$response($m) == 0} {
      puts $m
    }
  }   
}

if {$xerrors != 0} {

  set any_error 1

  puts "\nBad response from the following machines:\n"

  foreach m [array names xerror] {
    puts "$m ($xerror($m))"
  } 
}

if {$any_error == 0} {
  puts "\nNone"
}

agent_end
