#!/usr/contrib/bin/agent
#
# server.tcl
#
# This is the "server_agent".  It waits for a meeting request from any client
# using the get_meeting command.  Then it asks the user whether to accept
# or reject the meeting.  The client and server exchange two strings if the
# user accepts the meeting.

  # register the agent on the current machine

if {[catch agent_begin]} {
  return -code error "ERROR: unable to register the agent on $agent(actual-server)"
}

if {[catch {

    # this is the "server_agent"

  agent_force "$agent(local-ip) server_agent"
  agent_name server_agent

    # process meeting requests forever

  while {1} {

      # wait for the next meeting request

    set source_id [get_meeting source_loc -blocking]

     # ask the user to accept or reject the meeting

    puts "$source_id requests access to the server"
    puts "Accept (Y/N)?"

    while {[catch {gets stdin answer}]} {
      # empty -- this avoids the "gets" bug from the appendix
    }

      # on acceptance establish the connection and exchange information
      # on rejection send a rejection notice

    if {($answer == "Y") || ($answer == "y")} {
      set sockfd [accept_meeting $source_id $source_loc ANY]
      set status [tcpip_read $sockfd -blocking]
      puts "The client $source_id says ...\n$status"
      tcpip_write $sockfd "No problem!"
      tcpip_close $sockfd
    } else {
      reject_meeting $source_id
    }
  }
 
} error_message]} then {

    # make sure that we clean up on error

  agent_end

  return -code error -errorcode $errorCode -errorinfo $errorInfo $error_message

}

  # clean up

agent_end
