#!/usr/contrib/bin/agent
#
# server.two.tcl
#
# This is the second version of the "server_agent".  It waits for a meeting 
# request from any client and then automatically accepts the meeting request
# with the agent_accept command.

  # register the agent on the current machine

if {[catch agent_begin]} {
  return -code error "ERROR: unable to register the agent on $agent(actual-server)"
}

if {[catch {

    # this is the "server_agent"

  agent_force "$agent(local-ip) server_agent"
  agent_name server_agent

    # process meeting requests forever

  while {1} {

      # wait for the next meeting request

    set sockfd [agent_accept source_id source_loc ANY -blocking]

      # exchange the status strings

    set status [tcpip_read $sockfd -blocking]
    puts "The client $source_id says ...\n$status"
    tcpip_write $sockfd "No problem!"
    tcpip_close $sockfd
  }
 
} error_message]} then {

    # make sure that we clean up on error

  agent_end

  return -code error -errorcode $errorCode -errorinfo $errorInfo $error_message

}

  # clean up

agent_end
