#!/usr/contrib/bin/agent
#
# who.jump.tcl
#
# This agent executes the "who" command on multiple machines.  It submits
# a SINGLE child agent.  The child jumps from machine to machine and
# executes the WHO command on each machine.

  # Procedure WHO is the child agent that does the jumping.

proc who machines {

  global agent

    # start with an empty list

  set list ""

    # jump from machine to machine

  foreach m $machines {

      # if we do not jump successfully append an error message
      # otherwise append the list of users 

    if {[catch "agent_jump $m"]} {
      append list "$m:\nunable to JUMP to this machine\n\n"
    } else {
      set users [exec who]
      append list "$agent(local-server):\n$users\n\n"
    }
  }

  return $list
}
   
  # list of machines -- make sure that you replace these with your machines

set machines "muir.cs.dartmouth.edu \
	      tenaya.cs.dartmouth.edu \
	      tioga.cs.dartmouth.edu \
	      tuolomne.cs.dartmouth.edu \
	      m.cs.dartmouth.edu \
	      q.cs.dartmouth.edu \
	      bald.cs.dartmouth.edu"

  # register the agent

if {[catch {agent_begin}]} {
  return -code error "ERROR: unable to register on $agent(actual-server)"
}

  # catch any error

if {[catch {
 
    # submit the agent that does the jumping

  agent_submit $agent(local-ip) -vars machines -procs who -script {who $machines}

    # wait for the list of users

  agent_receive code message -blocking

    # output the list of users

  puts "\nWHO'S WHO on our computers\n\n$message"

} error_message]} then {

    # make sure that we clean up on error

  agent_end

  return -code error -errorcode $errorCode -errorinfo $errorInfo $error_message

}

  # cleanup

agent_end
