#!/usr/contrib/bin/agent
#
# who.tcl
#
# This agent executes the "who" command on multiple machines.  It submits one 
# child agent FOR EACH MACHINE.  Each child executes the "who" command on its 
# machine and returns the list of users.

  # Procedure WHO executes the "who" command

proc who args {

  global agent
  set users [exec who]
  return "$agent(local-server):\n$users\n"

}

  # list of machines -- make sure that you replace these with your machines!

set machines "bald.cs.dartmouth.edu \
	      muir.cs.dartmouth.edu \
	      tenaya.cs.dartmouth.edu \
	      tioga.cs.dartmouth.edu \
	      tuolomne.cs.dartmouth.edu"

  # register the agent

if {[catch {agent_begin}]} {
  return -code error "ERROR: unable to register on $agent(actual-server)"
}

  # catch any error

if {[catch {

    # submit the "who" agents

  set submitted 0

  foreach m $machines {

    set script "agent_submit $m -procs who -script {who}"

    if {[catch $script]} {
      puts "ERROR: unable to submit to $m"
    } else {
      incr submitted
    }

  }

    # wait for each child to send back a list of users

  puts "\nWHO'S WHO on our computers\n"

  for {set i 1} {$i <= $submitted} {incr i} {
    set source_id [agent_receive code message -blocking]
    puts $message
  }  

} error_message]} then {

    # make sure that we clean up on error

  agent_end

  return -code error -errorcode $errorCode -errorinfo $errorInfo $error_message

}

  # clean up

agent_end
