/* Agent Tcl
   Bob Gray
   8 September 1995

   tclRestrict.h

   This file defines the library routines that handle restrictions.

   Copyright (c) 1995, Robert S. Gray Dartmouth College

   See the file "agent.terms" for information on usage and redistribution
   of this file and for a DISCLAIMER OF ALL WARRANTIES.
*/

#ifndef _TCL_RESTRICT_H
#define _TCL_RESTRICT_H

#include "tcl.h"

#ifdef __cplusplus

#define EXTERN extern "C"

const PERMIT_WALL	= 0x1;  
const PERMIT_CPU	= 0x2;

#else

#define EXTERN extern

#define PERMIT_WALL	0x1
#define PERMIT_CPU	0x2

#endif

  /* a permit */

struct PERMIT_EXT
{
  int flags;     /* flags that indicate which permits are set */
  double wall;   /* limit on wall time                        */
  double cpu;    /* limit on cpu time                         */

#ifdef __cplusplus
  PERMIT_EXT (int flags, double wall, double cpu);
#endif
};

  /* initialize */

EXTERN int Restrict_Init 
	(Tcl_Interp *interp);

  /* parse a permit */

EXTERN struct PERMIT_EXT *Restrict_ParsePermit 
	(Tcl_Interp *interp, char *string);

  /* add and remove permits */

EXTERN int Restrict_AddPermit
	(Tcl_Interp *interp, PERMIT_EXT *permit);

EXTERN int Restrict_RemovePermit
	(Tcl_Interp *interp);

#endif
