#!/usr/contrib/bin/agent
#
# Agent Tcl
# Bob Gray
# 25 October 1995
#
# file.tcl
#
# Description:
#
# This file defines the "get_remote_file" procedure which is used to
# transfer a file from a remote machine to the local machine.
#
# Usage:
#
# get_remote_file <machine> <remote_name> <local_name>
#
# The procedure copies file <remote_name> from <machine> onto the local
# machine.  The file is given the name <local_name> on the local machine.

proc get_remote_file {machine file localFile} {

  global agent

    # "retriever" is sent to the remote machine where it handles
    # the remote side of file transfer

  proc retriever {file parent} {

      # open the file for reading

    set fd [open $file r]

      # send the okay to the parent

    agent_send $parent OKAY

      # meet with the parent

    set sockfd [agent_meet $parent]

      # transmit the file

    tcpip_write $sockfd from $fd

      # done

    tcpip_close $sockfd
    exit  
  }

    # open the destination file 

  set fd [open $localFile w]
   
    # submit the child that forms the other half of the file transfer

  set parent $agent(local)

  set code [
    catch {
      set child [
        agent_submit $machine -time 15.0 \
          -vars file parent -procs retriever -script {retriever $file $parent}
      ]
    } result
  ]

  if {$code != 0} {
    return -code error "child was not submitted: $result"
  }

     # wait for the child to say OK or ERROR

  set newMask [mask new]
  mask add $newMask $child
  set oldMask [mask_swap message $newMask]

  catch {
    agent_receive code string -time 15.0
  } result

  mask_replace message $oldMask

  if {$code != "0"} {
    return -code error "child failed: [lindex $string 0]"
  } elseif {$result == "-1"} {
    return -code error "no response from child"
  }

    # meet with the child

  set sockfd [agent_meet $child]

    # receive the file

  set code [
    catch {
      tcpip_read $sockfd to $fd -blocking
    } result
  ]

    # close the socket and return 

  tcpip_close $sockfd
  return -code $code $result
}  
