# Agent Tcl
# Bob Gray
# 4 October 1995
#
# This file defines the "retry" procedure.

proc retry {interval multiplier iterations script} glue {

  set i 1

  while {$i <= $iterations} {

    set code [catch {uplevel $script} result]

    if {$code == 0} {
      # TCL_OK;
      return $result
    } elseif {$code == 3} {
      # TCL_BREAK
      return -code break $result
    } elseif {$code == 4} {
      # TCL_CONTINUE
      return -code continue $result
    } 

    if {$i == $iterations} {
      global errorCode errorInfo
      return -code error -errorcode $errorCode -errorinfo $errorInfo $result
    }

    agent_sleep $interval

    set interval [expr {$interval * $multiplier}]
    incr i
  }
} 
