/* Agent Tcl
   Bob Gray
   15 February 1995

   agent_data.h

   This file defines the structures that keep track of agent data.

   Copyright (c) 1995, Robert S. Gray Dartmouth College

   See the file "agent.terms" for information on usage and redistribution
   of this file and for a DISCLAIMER OF ALL WARRANTIES.
*/

#ifndef _AGENT_DATA_H
#define _AGENT_DATA_H

#include "agentId.h"
#include "hash.h"
#include "message.h"
#include "my_sizes.h"
#include "queue.h"

  /* number of entries in the hash tables */

const HASH_ENTRIES    = 0x1000;  

  /* AGENT holds the data associated with an agent. */
  
struct AGENT
{
     /* queues for messages, meetings and events */

   QUEUE messages; 
   QUEUE meetings;
   QUEUE events;

   AGENT_ID *id;           /* actual location plus name plus numeric id   */
   UINT_32 pid;            /* process id of the agent                     */ 
   UINT_32 blocked_pid;    /* process id of the blocked agent handler     */
   int blocked_item;       /* TRUE if the agent handler has blocked while */
                           /* waiting for a message, meeting or event     */

     /* constructor and destructor */

   AGENT (AGENT_ID *id);
  ~AGENT ();
};

  /* AGENT_DATA holds the data for all agents.                   */
  /* The data consists of the next available numeric id, a table */
  /* of agents and a table of agent names                        */
               
class AGENT_DATA
{
   unsigned num_agents;  /* number of agents in the system  */
   INT_32 next_id;       /* potential id for the next agent */
   HASH  *agent_table;   /* hash table for agents           */
   HASH  *name_table;    /* hash table for agent names      */

     /* lookup the recipient agent */

   AGENT *lookup_recipient (UINT_32 id, char *name);  

 public:
 
     /* constructor and destructor */

   AGENT_DATA (void);
   ~AGENT_DATA ();
 
     /* handle begin, end, name, pid, messages, meetings, events */
     /* and information requests                                 */

   MESSAGE *agent_begin   (MESSAGE *message);
   MESSAGE *agent_end     (MESSAGE *message);
   MESSAGE *agent_name    (MESSAGE *message);
   MESSAGE *agent_send    (MESSAGE *message);
   MESSAGE *agent_req     (MESSAGE *message);
   MESSAGE *agent_event   (MESSAGE *message);
   MESSAGE *agent_receive (MESSAGE *message);
   MESSAGE *agent_info    (MESSAGE *message);
};
     
#endif
