/* Agent Tcl
   Bob Gray
   25 February 1995

   agentd.h

   This file defines the data structures for the agent server.
   
   Copyright (c) 1995, Robert S. Gray Dartmouth College

   See the file "agent.terms" for information on usage and redistribution
   of this file and for a DISCLAIMER OF ALL WARRANTIES.
*/

#ifndef _AGENTD_H
#define _AGENTD_H

#include "agent_data.h"
#include "my_sizes.h"
#include "truefalse.h"

class ERROR;
class HASH;

  /* default is to run the server as a daemon and to have no tracker agent */

const defaultDaemon  = TRUE;
const defaultTracker = FALSE;
 
  /* server and agent information */

struct SERVER_DATA
{
  int daemon;          /* TRUE if we are running the process as a daemon             */
  int tracker;         /* TRUE if there is a tracker agent controlling access        */
  char *host_name;     /* Internet name of the host on which the server is running   */
  UINT_32 host_ip;     /* IP number of the host on which the server is running       */ 
  char *error;         /* file in which to log errors                                */
  char *lock;          /* file that is locked/unlocked to control access to the pipe */
  char *access;        /* file which contains the access list                        */
  char *lang;          /* file which contains the set of interpreters                */  
  int lockfd;          /* file descriptor of the lock file                           */
  int sockfd;          /* socket descriptor that brings in remote requests           */  
  int streamSocketd;   /* stream pipe to/from socketd                                */
  int streamAgentd;    /* stream pipe to/from agentd                                 */ 
  ERROR *errorlog;     /* error logger                                               */
  HASH *interp_table;  /* interpreters that are available through the server         */
  HASH *access_table;  /* IP addresses of the machines that are allowed access       */
};  

  /* agent information */

extern SERVER_DATA *server_data;   
extern AGENT_DATA  *agent_data;
	
#endif 
