/* Agent Tcl
   Bob Gray
   23 August 1995

   interp.cc

   This file implements the routines that keep track of available interpreters.
*/

#include <stdio.h>
#include <stdlib.h>
#include "interp.h"
#include "my_alloc.h"
#include "my_strings.h"

/* INTERP::INTERP and INTERP::~INTERP

   Purpose: These procedures are the constructor and destructor for struct
            INTERP.  The destructor assumes that all of the strings in the
            structure are dynamically allocated.
*/

INTERP::INTERP (char *name, char *executable, char *argv0, char *sock_dir, int type)
{
  INTERP::name        = my_strcpy (name);
  INTERP::executable  = my_strcpy (executable);
  INTERP::argv0       = my_strcpy (argv0);
  INTERP::sock_dir    = my_strcpy (sock_dir);
  INTERP::interp_type = type; 
}

INTERP::~INTERP ()
{
  delete_check (name);
  delete_check (executable);
  delete_check (argv0);
  delete_check (sock_dir);
}
