/* Agent Tcl
   Bob Gray
   23 August 1995

   interp.h

   This file defines the routines that keep track of available interpreters.
*/

#ifndef _INTERP_H
#define _INTERP_H

  /* interpreter accepts state images or just scripts */

const STATE_INTERP  = 0;
const NORMAL_INTERP = 1;

  /* struct INTERP holds the information on one interpreter */

struct INTERP
{
  char *name;        /* symbolic name for the interpreter               */
  char *executable;  /* executable file that starts the interpreter     */
  char *argv0;       /* argv[0] that is passed to the executable        */
  char *sock_dir;    /* directory in which to create named Unix sockets */
  int interp_type;   /* STATE_INTERP or NORMAL_INTERP                   */

    /* constructor and destructor */

  INTERP (char *name, char *executable, char *argv0, char *sock_dir, int type);
  ~INTERP ();
};



#endif
