/* Agent Tcl
   Bob Gray
   23 August 1995

   parse.cc

   This file implements the parsing routines.

   Copyright (c) 1995, Robert S. Gray Dartmouth College

   See the file "agent.terms" for information on usage and redistribution
   of this file and for a DISCLAIMER OF ALL WARRANTIES.
*/

#include <stdio.h>
#include <stdlib.h>
#include "my_strings.h"
#include "parse.h"

/* PARSE::skip_comment

   Purpose: Skip over a comment
 
     Input: None

    Output: The procedure reads through the file until it hits a \n or an EOF.
*/

void PARSE::skip_comment (void)
{
  while ((ch != '\n') && (ch != EOF)) {
    ch = fgetc (fp);
  }
}

/* PARSE::PARSE

   Purpose: This procedure is the constructor for class PARSE.

     Input: fp   = the file to be parsed
            size = maximum word length
 
    Output: The procedure initializes the parser.  Note that the procedure
            assumes that the file has been opened for reading and that no
            I/O operations have been performed on the file yet.
*/

PARSE::PARSE (FILE *fp, int size)
{
  setvbuf (fp, NULL, _IOFBF, 0);
  PARSE::fp      = fp;
  PARSE::size    = size;
  PARSE::buffer  = new char [size + 1];
  PARSE::line    = 1;
  PARSE::ch      = fgetc (fp);
}

/* PARSE::next_word
 
   Purpose: Get the next word in the file

     Input: None

    Output: The procedure returns -1 on error.  The most common error is
            a word being longer than the buffer size.  Otherwise the procedure
            returns 0 and sets *bufferPtr to NULL if there are no words left
            in the file or to a dynamically allocated string that contains the
            next word.
*/

int PARSE::next_word (char **bufferPtr)
{
  int i = 0;

    /* skip over whitespace */

  while ((ch == ' ') || (ch == '\t') || (ch == '\n') || (ch == '#')) {
    if (ch == '\n') {
      line += 1;
      ch = fgetc (fp);
    } else if (ch == '#') {
      skip_comment ();
    } else {
      ch = fgetc (fp);
    }
  } 
  
    /* assemble the word */ 

  while ((ch != EOF) && (ch != ' ') && (ch != '\t') && (ch != '\n') && (ch != '#')) {
    if (i >= size) {
      return -1; 
    } else {
      buffer[i] = ch;
      i += 1;
    }

    ch = fgetc (fp);
  } 

  buffer[i] = '\0';

    /* set the bufferPtr as appropriate */

  if (i == 0) {
    *bufferPtr = NULL;
  } else {
    *bufferPtr = my_strcpy (buffer);
  }

  return 0;
}
