/* Agent Tcl
   Bob Gray
   15 February 1995

   piped.cc

   This file implements "piped" which monitors the pipe from socketd to
   agentd.

   Copyright (c) 1995, Robert S. Gray Dartmouth College

   See the file "agent.terms" for information on usage and redistribution
   of this file and for a DISCLAIMER OF ALL WARRANTIES.
*/

#include <sys/types.h>
#ifndef COSMO
#include <unistd.h>
#else
#include </usr/local/lib/gcc-lib/rs6000-ibm-aix3.2.5/2.6.3/include/unistd.h>
#endif
#include <stdio.h>
#include <stdlib.h>
#include "agentd.h"
#include "agent_data.h"
#include "error.h"
#include "piped.h"
#include "message.h"
#include "transmit.h"

typedef MESSAGE * (AGENT_DATA::*Action) (MESSAGE *);

static Action jumpTable[NUM_REQUESTS] =
{
  &AGENT_DATA::agent_begin,       /* REQ_BEGIN     */
  &AGENT_DATA::agent_name,        /* REQ_NAME      */
  &AGENT_DATA::agent_end,         /* REQ_END       */
  NULL,                           /* REQ_SCRIPT    */
  NULL,                           /* REQ_STATE     */
  &AGENT_DATA::agent_send,        /* REQ_MESSAGE   */
  &AGENT_DATA::agent_req,         /* REQ_MEETING   */
  &AGENT_DATA::agent_event,       /* REQ_EVENT     */
  &AGENT_DATA::agent_receive,     /* REQ_GET       */
  NULL,				  /* REQ_ENCRYPTED */
  &AGENT_DATA::agent_info,	  /* REQ_INFO      */ 
  NULL				  /* REQ_SIGN      */
};
 
/* piped

   Purpose: Monitor the pipe that carries requests from socketd to agentd

     Input: None

    Output: The procedure should never return.
*/

void piped (void)
{
  register MESSAGE *message;
  register MESSAGE *mesg_to_socketd;

    /* wait for requests on the pipe */
 
  while (1) {

    mesg_to_socketd = NULL;

      /* receive the incoming message */

    if ((message = message_receive (server_data -> streamSocketd, up_pipe)) == NULL) {
      server_data -> errorlog -> 
        error_app_quit 
	  ("agentd: invalid or incomplete message\n");
    }

      /* handle the message */

    if (jumpTable[message -> flag] != NULL) {

      mesg_to_socketd = (agent_data->*jumpTable[message -> flag]) (message);

    } else {

      server_data -> errorlog ->
        error_app_quit 
          ("agentd: REQ_SCRIPT and REQ_STATE are not supported");
    } 

      /* send the response message down the pipe */

    message_send (server_data -> streamSocketd, *mesg_to_socketd);
    delete mesg_to_socketd;
    delete message;
  }
}
