/* Agent Tcl
   Bob Gray
   9 February 1995

   socketd.cc

   This file implements procedure "socketd" which monitors the TCP/IP port.

   Copyright (c) 1995, Robert S. Gray Dartmouth College

   See the file "agent.terms" for information on usage and redistribution
   of this file and for a DISCLAIMER OF ALL WARRANTIES.
*/

#include <sys/types.h>
#include <sys/socket.h>
#include <signal.h>
#include <fcntl.h>
#ifndef COSMO
#include <sys/wait.h>
#else
#include </usr/local/lib/gcc-lib/rs6000-ibm-aix3.2.5/2.6.3/include/sys/wait.h>
#endif
#include <netinet/in.h>
#ifdef SYSV
#ifndef SOLARIS
#include <bstring.h>
#endif
#endif
#include <errno.h>
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#ifndef COSMO
#include <unistd.h>
#else
#include </usr/local/lib/gcc-lib/rs6000-ibm-aix3.2.5/2.6.3/include/unistd.h>
#endif
#include "agentd.h"
#include "error.h"
#include "interrupt.h"
#include "socketd.h"
#include "tcl_receive.h"
#include "tcpip.h"
#include "truefalse.h"

/* socketd

   Purpose: This procedure monitors the TCP/IP port. 
*/

static void sigchld_handler (int signo)
{
   int status;  

   while (waitpid(0, &status, WNOHANG) > 0);

   return;
}

static void sigusr1_handler (int signo)
{
   return;
}

static void sigio_handler (int signo)
{
   return;
}

void create_lock_file (void)
{
  int fd;

  if ((fd = open (server_data -> lock, O_RDWR | O_TRUNC | O_CREAT, 0600)) < 0) {
    server_data -> errorlog ->
      error_sys_quit ("socketd: unable to open lock file");
  }

  server_data -> lockfd = fd;  
}

void socketd (void)
{
  int newSockfd;      /* socket descriptor for a connection */
  pid_t childpid;     /* process id of a forked child       */
  
    /* install the SIGCHLD handler             */
    /* install the SIGUSR1 handler             */
    /* install the SIGIO handler               */   
    /* inherit the SIGPIPE handler from agentd */

  if (install_signal_intr (SIGCHLD, (void (*)(...)) sigchld_handler, 0) < 0) {
    server_data -> errorlog ->
      error_sys_quit 
        ("socketd: unable to install SIGCHLD handler");
  }
 
  if (install_signal_intr (SIGIO, (void (*)(...)) sigio_handler, 0) < 0) {
    server_data -> errorlog ->
      error_sys_quit
        ("socketd: unable to install SIGIO handler");
  }
  
  if (install_signal_intr (SIGUSR1, (void (*)(...)) sigusr1_handler, 0) < 0) {
    server_data -> errorlog ->
      error_sys_quit
        ("socketd: unable to install SIGUSR1 handler");
  }
  
    /* wait for a connection from a client process */

  while (1) {

    while ((newSockfd = tcpip_accept (server_data -> sockfd)) < 0) {
      server_data -> errorlog ->
        error_sys_cont 
          ("socketd: unable to accept connection");
    }

    if ((childpid = fork()) < 0) {
 
        /* FORK FAILED */

      server_data -> errorlog ->
        error_sys_quit 
          ("socketd: unable to fork child process");

    } else if (childpid == 0) {

        /* CHILD PROCESS */

      close (server_data -> sockfd);
      create_lock_file ();
      tcl_action (newSockfd);
      exit (0);

    } else {
 
        /* PARENT PROCESS */

      close (newSockfd); 
    }
  } 
}

