/* Agent Tcl
 * Bob Gray
 * 25 January 1995
 * 
 * *** DIFFERENT THAN THE STANDARD TCL DISTRIBUTION ***
 *
 * tclInit.h --
 *
 *	This file contains a modified version of the Tcl_Init function.
 *
 * Copyright (c) 1995, Robert S. Gray, Dartmouth College
 * Copyright (c) 1987-1993 The Regents of the University of California.
 * Copyright (c) 1994 Sun Microsystems, Inc.
 *
 * See the file "agent.terms" for information on usage and redistribution
 * of this file, and for a DISCLAIMER OF ALL WARRANTIES.
 */

#include "tclInt.h"
#ifndef TCL_GENERIC_ONLY
#include "tclPort.h"
#endif

/*
 * The following variable is a special hack that is needed in order for
 * Sun shared libraries to be used for Tcl.
 */

extern int matherr();
int *tclDummyMathPtr = (int *) matherr;

/* Tcl_Init
 *
 * Purpose: Perform application specific initialization of the Tcl
 *          interpreter
 *
 *   Input: interp = Tcl interpreter
 */

int Tcl_Init (interp)
     Tcl_Interp *interp;
{
  char *libDir;
 
  static char initCmd[] =
    "if [file exists [info library]/init.tcl] {\n\
       source [info library]/init.tcl\n\
     } else {\n\
       set msg \"can't find [info library]/init.tcl; perhaps you \"\n\
       append msg \"need to\\ninstall Tcl or set your TCL_LIBRARY \"\n\
       append msg \"environment variable?\"\n\
       error $msg\n\
    }";

    /* source the init.tcl script */

  Tcl_GlobalEval(interp, initCmd);
  return (interp -> resultCode);
}
