/* Agent Tcl
   Bob Gray
   24 June 1995

   tclTcpip.h

   This file defines the TCPIP library routines.

   Copyright (c) 1995, Robert S. Gray Dartmouth College

   See the file "agent.terms" for information on usage and redistribution
   of this file and for a DISCLAIMER OF ALL WARRANTIES.
*/

#ifndef _TCL_TCPIP_H
#define _TCL_TCPIP_H

#include <stdio.h>
#include "agentId.h"
#include "my_sizes.h"
#include "tcl.h"

#ifdef __cplusplus

#define EXTERN extern "C"

  /* local or remote end of a connected socket */
  
const LOCAL_PEER		= 0;
const REMOTE_PEER		= 1;

  /* default timeout when connecting */

const DEFAULT_TCPIP_SECONDS	= 15;

#else

#define EXTERN extern

  /* local or remote end of a connected socket */

#define LOCAL_PEER		0
#define REMOTE_PEER		1

  /* default timeout when connecting */

#define DEFAULT_TCPIP_SECONDS	15

#endif

  /* add the tcpip commands into the interpreter */

EXTERN int Tcpip_Init 
	(Tcl_Interp *interp);

  /* create a socket, bind, listen, connect, accept and close a socket */

EXTERN int Tcpip_Socket  
	(Tcl_Interp *interp);        

EXTERN int Tcpip_Bind    
	(Tcl_Interp *interp, int sockfd, int port);

EXTERN int Tcpip_Listen  
	(Tcl_Interp *interp, int sockfd);

EXTERN int Tcpip_Connect 
	(Tcl_Interp *interp, double seconds, int sockfd, 
	 struct REMOTE_PORT *port);

EXTERN int Tcpip_Accept  
	(Tcl_Interp *interp, double seconds, int sockfd);

EXTERN int Tcpip_Close   
	(Tcl_Interp *interp, int sockfd);   

   /* get the name of the current host */
   /* get the IP number of a host      */

EXTERN char *Tcpip_Hostname 
	(Tcl_Interp *interp);

EXTERN int Tcpip_Getip
	(Tcl_Interp *interp, char *machine, UINT_32 *ip);

EXTERN struct REMOTE_PORT *Tcpip_Getport 
	(Tcl_Interp *interp, int sockfd, int peer);

   /* read and write strings */

EXTERN int Tcpip_Write 
	(Tcl_Interp *interp, int sockfd, char *string);

EXTERN char *Tcpip_Read  
	(Tcl_Interp *interp, double seconds, int sockfd);

   /* read from a socket into a file and write to a socket from a file */

EXTERN int Tcpip_WriteFromFile
	(Tcl_Interp *interp, int sockfd, FILE *fptr);

EXTERN int Tcpip_ReadToFile
	(Tcl_Interp *interp, double seconds, int sockfd, FILE *fptr);

   /* utility routines */

EXTERN Tcl_DString *Tcpip_PortToString
	(Tcl_Interp *interp, struct REMOTE_PORT *port);
 
EXTERN struct REMOTE_PORT *Tcpip_SplitPort
	(Tcl_Interp *interp, char *string);

EXTERN char *Tcpip_IpToString
	(Tcl_Interp *interp, UINT_32 ip);

EXTERN int Tcpip_StringToIp
	(Tcl_Interp *interp, char *string, UINT_32 *ip);
  
#endif
