/* Agent Tcl
   Bob Gray
   14 August 1995 

   cmd_utilities.h

   This file implements utilities for parsing Tcl commands.

   Copyright (c) 1995, Robert S. Gray Dartmouth College

   See the file "agent.terms" for information on usage and redistribution
   of this file and for a DISCLAIMER OF ALL WARRANTIES.
*/

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include "cmd_utilities.h"
#include "my_sizes.h"
#include "tcl.h"
#include "tclAgent.h"

  /* parse the [-time seconds] section of a cmd */

int parseShortTimeout (Tcl_Interp *interp, double &seconds, int argc, char **argv, int i)
{
    /* check for the -time option */

  if (strcmp (argv[i], "-time")) {
    Tcl_AppendResult (interp, "unknown option \"", argv[i], "\": should be \"-time\"", (char *) NULL);
    return -1;
  } 

    /* get the number of seconds */

  if (++i == argc) {
    Tcl_AppendResult (interp, "\"-time\" must be followed by the number of seconds", (char *) NULL);
    return -1;
  } else if (Tcl_GetDouble (interp, argv[i], &seconds) != TCL_OK) { 
    Tcl_AppendResult (interp, ": seconds must be a real number", (char *) NULL);
    return -1;
  } else if (seconds < 0.0) {
    Tcl_AppendResult (interp, "seconds must be 0 or greater", (char *) NULL);
    return -1;
  }

    /* we got the number of seconds */

  return i;
}
 
  /* parse the [-blocking | -time seconds | -nonblocking] section of a cmd */

int parseTimeout (Tcl_Interp *interp, double &seconds, int argc, char **argv, int i)
{
   /* check for the -time option */

  if (!strcmp (argv[i], "-blocking")) {
    seconds  = -1.0;
  } else if (!strcmp (argv[i], "-nonblocking")) {
    seconds = 0.0; 
  } else if (!strcmp (argv[i], "-time")) {

      /* get the number of seconds */

    if (++i == argc) {
      Tcl_SetResult (interp, "-time must be followed by the number of seconds", TCL_STATIC);
      return -1;
    } else if (!strcmp(argv[i], "forever")) {
      seconds = -1.0;
    } else if (Tcl_GetDouble (interp, argv[i], &seconds) != TCL_OK) { 
      Tcl_SetResult (interp, "-time must be followed by the number of seconds", TCL_STATIC);
      return -1;
    }
  } else {
    Tcl_SetResult (interp, "expected -time, -blocking or -nonblocking", TCL_STATIC);
    return -1;
  } 

    /* we got the number of seconds */

  return ++i;
} 
