/* Agent Tcl
   Bob Gray
   18 February 1995

   daemon.cc

   This file implements the procedure that turns a process into a daemon.
   This procedure is based on the examples in  "Unix Network Programming" by 
   W. Richard Stevens [Prentice-Hall Software Series, 1990].

   Copyright (c) 1995, Robert S. Gray Dartmouth College

   See the file "agent.terms" for information on usage and redistribution
   of this file and for a DISCLAIMER OF ALL WARRANTIES.
*/

#include <sys/types.h>
#include <sys/param.h>
#include <sys/file.h>
#include <sys/ioctl.h>
#include <sys/stat.h>
#include <errno.h>
#include <signal.h>
#include <stdio.h>
#include <stdlib.h>
#ifndef COSMO
#include <unistd.h>
#else
#include </usr/local/lib/gcc-lib/rs6000-ibm-aix3.2.5/2.6.3/include/unistd.h>
#endif

extern int errno;

/* make_daemon

   Purpose: Turn a process into a daemon -- i.e. "detach the process from
            its login session context"

     Input: None

    Output: The procedure aborts on any error.  Otherwise the procedure
            returns with the process now a daemon.
*/

void make_daemon (void)
{
  register pid_t childPid;   /* id of child process */

    /* do not need to detach if the process was started by inittab - */
    /* i.e. do not need to detach if the parent process id is 1      */    
    /* NOTE that this test is unreliable since the parent id could   */
    /* be 1 either if (1) inittab started the process or (2) the     */
    /* process was orhpaned by some other parent before the test     */
    /* occurs                                                        */
 
  if (getppid() != 1)
  {
      /* ignore the terminal stop signals */

#ifdef SIGTTOU
    signal (SIGTTOU, (void (*)(...)) SIG_IGN);
#endif
#ifdef SIGTTIN
    signal (SIGTTIN, (void (*)(...)) SIG_IGN);
#endif
#ifdef SIGTSTP
    signal (SIGTSTP, (void (*)(...)) SIG_IGN);
#endif 

      /* fork and let the parent exit in case the daemon was not */
      /* started in the background; in addition this guarantees  */
      /* that the child is not a process group leader            */

    if ((childPid = fork()) < 0)
    {
      fprintf (stderr, "make_daemon: unable to fork child");    
      exit (1);
    }
    else if (childPid > 0)     /* parent */
    {
      exit (0);
    }

      /* disassociate the child from controlling terminal and process group */

    setsid ();
  }

    /* switch to root directory so we're not on a mounted filesystem */

  chdir ("/");

    /* clear file mode creation mask */

  umask (0);
}  
