/* Agent Tcl
   Bob Gray
   22 February 1995

   error.h

   This file defines class ERROR which provides an error logging facility. 
   ERROR is based on the error logged facilities in "UNIX Network Programming"
   by W. Richard Stevens [Prentice-Hall, 1990].
   
   Copyright 1995, Robert S. Gray, Department of Computer Science, Dartmouth
*/

#ifndef _ERROR_H
#define _ERROR_H

class ERROR
{
    int use_stderr;     /* TRUE if error message should be sent to stderr */
    int logfd;          /* file descriptor for the log file               */
    char *logname;      /* path name of the log file                      */

      /* open and close the error log */

    int open_log   (void);
    void close_log (void);
 
      /* log the date */

    void error_date (void);

  public:

      /* constructor and destructor */

    ERROR (char *logname);
   ~ERROR (); 

      /* log error messages */

    void error_sys_cont (char *message);
    void error_sys_quit (char *message);
    void error_app_cont (char *message);
    void error_app_quit (char *message);
};

#endif
