/* Agent Tcl
   Bob Gray
   14 August 1995 

   fd_utilities.cc

   This file implements utilities for handling file I/O.

   Copyright (c) 1995, Robert S. Gray Dartmouth College

   See the file "agent.terms" for information on usage and redistribution
   of this file and for a DISCLAIMER OF ALL WARRANTIES.
*/


#include <sys/types.h>
#include <sys/time.h>
#include <sys/stat.h>
#ifdef AIX
#include <sys/select.h>
#endif
#include <sys/socket.h>
#include <assert.h>
#ifdef SYSV
#ifndef SOLARIS
#include <bstring.h>
#endif
#endif
#include <errno.h>
#include <fcntl.h>
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#ifndef COSMO
#include <unistd.h>
#else
#include </usr/local/lib/gcc-lib/rs6000-ibm-aix3.2.5/2.6.3/include/unistd.h>
#endif
#include "fd_utilities.h"
#include "tcl.h"
#include "timers.h"

  /* wait for a file descriptor to be ready for reading */

int fileWaitForRead (Tcl_Interp *interp, int fd, clock_t stop)  
{  
  int code;
  fd_set readSet;         
  struct timeval timeout;
  struct timeval *timeoutPtr;
  int returnCode = TCL_ERROR;

    /* assertions on the parameters */

  assert (interp != NULL);
  assert (fd >= 0);

    /* make a set that contains the socket descriptor */

  do {

    FD_ZERO (&readSet);
    FD_SET (fd, &readSet);
    timeoutPtr = TIMERS::ticksToTimeval (stop, timeout);
    code = select (fd + 1, &readSet, NULL, NULL, timeoutPtr);

  } while ((code < 0) && (errno == EINTR));

    /* error or time out or okay */

  if (code < 0) {
    Tcl_AppendResult (interp, "unable to select on sockfd", (char *) NULL);
  } else if (code == 0) {
    Tcl_AppendResult (interp, "timeout", (char *) NULL);
    Tcl_SetErrorCode (interp, "TIMEOUT", (char *) NULL);
  } else {
    returnCode = TCL_OK;
  } 

  return (returnCode);
}
