/* Agent Tcl
   Bob Gray
   14 August 1995 

   fd_utilities.h

   This file defines utilities for handling file I/O.

   Copyright (c) 1995, Robert S. Gray Dartmouth College

   See the file "agent.terms" for information on usage and redistribution
   of this file and for a DISCLAIMER OF ALL WARRANTIES.
*/

#ifndef _FD_UTILITIES_H
#define _FD_UTILITIES_H

#include <sys/types.h>
#ifndef COSMO
#include <unistd.h>
#else
#include </usr/local/lib/gcc-lib/rs6000-ibm-aix3.2.5/2.6.3/include/unistd.h>
#endif
#include "tcl.h"

  /* close */

inline void close_check (int fd) {
  if (fd >= 0) {
    close (fd);
  }
}

  /* wait for a file descriptor to be ready for reading */

int fileWaitForRead (Tcl_Interp *interp, int fd, clock_t stop);

#endif  
