/* Agent Tcl
   Bob Gray
   5 April 1995

   hash.h

   This file defines hash table classes.

   Copyright (c) 1995, Robert S. Gray Dartmouth College

   See the file "agent.terms" for information on usage and redistribution
   of this file and for a DISCLAIMER OF ALL WARRANTIES.
*/

#ifndef _HASH_H
#define _HASH_H

  /* It is assumed that the data in a hash node is STATICALLY ALLOCATED. */
  /* It will NOT be freed automatically when the hash table is deleted.  */

struct HASH_NODE
{
  long key;            /* integer key                  */
  char *string_key;    /* string key                   */ 
  void *data;          /* pointer to the node data     */ 
  HASH_NODE *next;     /* next node in a list of nodes */

   /* constructor and destructor */

  HASH_NODE (long key, char *string_key, void *data, HASH_NODE *next);
  ~HASH_NODE ();
};

class HASH
{
    friend class HASH_SEARCH;
    unsigned entries;    /* number of entries in the table */
    unsigned max_index;  /* maximum table index            */
    HASH_NODE **table;   /* hash table                     */

    inline long hash (long &key, char *string_key)
    {
       register char *sp = string_key;

       if (sp != NULL) {
         for (key = 0; *sp != '\0'; sp++) {
           key = key << 3 + key + *sp;
         }
       }

       return key & max_index;
    }

  public:

      /* constructor and destructor */

    HASH (unsigned entries);
    ~HASH ();

      /* get the number of entries */

    inline unsigned get_entries (void) { return entries; };

      /* add, lookup, search and remove entries */  

    HASH_NODE *add    (long key, char *string_key, void *data, int &there);
    HASH_NODE *lookup (long key, char *string_key);
    int        remove (long key, char *string_key); 
};

class HASH_SEARCH  
{
    HASH *hash;       /* hash table associated with this search */
    unsigned bucket;  /* current bucket of the hash table       */
    HASH_NODE *node;  /* current node of the hash table         */

  public:

      /* constructor */

    HASH_SEARCH::HASH_SEARCH (HASH *hash);

      /* get next node in the hash table */

    HASH_NODE *next (void); 
};

#endif
