/* Agent Tcl
   Bob Gray
   14 February 1995

   interrupt.cc

   This file implements a reliable signal handler "install_signal".  This
   handler is based on the examples in "UNIX Network Programming" by W. Richard
   Stevens [Prentice-Hall, 1990].

   Copyright (c) 1995, Robert S. Gray Dartmouth College

   See the file "agent.terms" for information on usage and redistribution
   of this file and for a DISCLAIMER OF ALL WARRANTIES.
*/

#include "interrupt.h"

int install_signal (int signo, void (*func) (...), int flags)
{
  struct sigaction act;   /* signal handler information */

  act.sa_handler = func;
  sigemptyset (&act.sa_mask);
  act.sa_flags   = flags;

  if (signo == SIGALRM) {  
#ifdef SA_INTERRUPT
    act.sa_flags |= SA_INTERRUPT;     
#endif
  } else {
#ifdef SA_RESTART
    act.sa_flags |= SA_RESTART;
#endif
  }

  if (sigaction(signo, &act, 0) < 0) {
    return -1;
  }

  return 0;
}

int install_signal_intr (int signo, void (*func) (...), int flags)
{
  struct sigaction act;   /* signal handler information */

  act.sa_handler = func;
  sigemptyset (&act.sa_mask);
  act.sa_flags   = flags;

#ifdef SA_INTERRUPT
  act.sa_flags |= SA_INTERRUPT;     
#endif

  if (sigaction(signo, &act, 0) < 0) {
    return -1;
  }

  return 0;
}
