/* Agent Tcl
   Bob Gray
   1 July 1995

   locks.cc

   This file implements the routines that set and release file locks.

   Copyright (c) 1995, Robert S. Gray Dartmouth College

   See the file "agent.terms" for information on usage and redistribution
   of this file and for a DISCLAIMER OF ALL WARRANTIES.
*/

#include <sys/types.h>
#include <sys/file.h>
#include <stdio.h>
#include <stdlib.h>
#include <errno.h>
#ifndef COSMO
#include <unistd.h>
#else
#include </usr/local/lib/gcc-lib/rs6000-ibm-aix3.2.5/2.6.3/include/unistd.h>
#endif
#include "error.h"
#include "locks.h"

#ifndef SYSV
extern "C" int flock (int, int);
#endif

void get_lock (int fd, ERROR *errorlog)
{
  int return_code;

#ifdef SYSV
  lseek (fd, 0, SEEK_SET);
#endif

  do {

#ifdef SYSV
    return_code = lockf (fd, F_LOCK, 0);
#else
    return_code = flock (fd, LOCK_EX);
#endif

  } while ((return_code < 0) && (errno == EINTR));

  if (return_code < 0) {
    if (errorlog) {
      errorlog -> error_sys_quit ("unable to release lock\n");
    } else {
      fprintf (stderr, "unable to release lock");
      exit (1);
    } 
  }
}

void release_lock (int fd, ERROR *errorlog)
{
  int return_code;
    
#ifdef SYSV
  lseek (fd, 0, SEEK_SET);
#endif

  do {

#ifdef SYSV
    return_code = lockf (fd, F_ULOCK, 0);
#else
    return_code = flock (fd, LOCK_UN);
#endif

  } while ((return_code < 0) && (errno == EINTR));

  if (return_code < 0) {
    if (errorlog) {
      errorlog -> error_sys_quit ("unable to release lock\n");
    } else {
      fprintf (stderr, "unable to release lock");
      exit (1);
    } 
  }
}
